/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.automobile.model;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.foundationgames.automobility.automobile.model.ModelType;
import java.util.function.Function;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.StringRepresentable;
import org.joml.Vector3f;

public record ModelDefinition(ModelType type, RenderMaterial material, ModelLayerLocation modelLayer, Vector3f translation, Vector3f rotation, Vector3f scale) {
    public static final Codec<ModelLayerLocation> LAYER_CODEC = ResourceLocation.CODEC.xmap(rl -> {
        int layerStart = rl.getPath().lastIndexOf("/");
        String modelPath = rl.getPath().substring(0, layerStart);
        String layerPath = rl.getPath().substring(layerStart + 1);
        return new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)rl.getNamespace(), (String)modelPath), layerPath);
    }, ml -> ResourceLocation.fromNamespaceAndPath((String)ml.getModel().getNamespace(), (String)(ml.getModel().getPath() + "/" + ml.getLayer())));
    public static final Codec<ModelDefinition> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)ModelType.CODEC.fieldOf("type").forGetter(ModelDefinition::type), (App)RenderMaterial.CODEC.fieldOf("material").forGetter(ModelDefinition::material), (App)LAYER_CODEC.fieldOf("model_layer").forGetter(ModelDefinition::modelLayer), (App)ExtraCodecs.VECTOR3F.optionalFieldOf("translation", (Object)new Vector3f()).forGetter(ModelDefinition::translation), (App)ExtraCodecs.VECTOR3F.optionalFieldOf("rotation", (Object)new Vector3f()).forGetter(ModelDefinition::rotation), (App)ExtraCodecs.VECTOR3F.optionalFieldOf("scale", (Object)new Vector3f(1.0f)).forGetter(ModelDefinition::scale)).apply((Applicative)inst, ModelDefinition::new));

    public static ModelDefinition of(ModelType type, RenderMaterial material, ModelLayerLocation modelLayer) {
        return ModelDefinition.ofYaw(type, material, modelLayer, 0.0f);
    }

    public static ModelDefinition ofYaw(ModelType type, RenderMaterial material, ModelLayerLocation modelLayer, float yaw) {
        return new ModelDefinition(type, material, modelLayer, new Vector3f(), new Vector3f(0.0f, yaw, 0.0f), new Vector3f(1.0f));
    }

    public static ModelDefinition ofScale(ModelType type, RenderMaterial material, ModelLayerLocation modelLayer, float scale) {
        return new ModelDefinition(type, material, modelLayer, new Vector3f(), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(scale));
    }

    public Model createModel(EntityRendererProvider.Context ctx) {
        return this.type().provider().create(ctx, this.material(), this.modelLayer(), this.translation(), this.rotation(), this.scale());
    }

    public static enum RenderMaterial implements StringRepresentable
    {
        SOLID("solid", RenderType::entitySolid),
        CUTOUT("cutout", RenderType::entityCutout),
        CUTOUT_NO_CULL("cutout_backfaces", RenderType::entityCutoutNoCull),
        TRANSLUCENT("translucent", RenderType::entityTranslucentCull),
        TRANSLUCENT_NO_CULL("translucent_backfaces", RenderType::entityTranslucent),
        ADDITIVE_TRANSLUCENT("additive_translucent", RenderType::eyes),
        EMISSIVE("emissive", RenderType::breezeEyes);

        public static final Codec<RenderMaterial> CODEC;
        public final String id;
        public final Function<ResourceLocation, RenderType> renderType;

        private RenderMaterial(String id, Function<ResourceLocation, RenderType> renderType) {
            this.id = id;
            this.renderType = renderType;
        }

        public String getSerializedName() {
            return this.id;
        }

        static {
            CODEC = StringRepresentable.fromEnum(RenderMaterial::values);
        }
    }
}

